/**
 * This is a sample application program which is built using the classes generated 
 * by the XML DTD Class Generator using the DTD "Checkbook.dtd". 
 * This application also demonstrates the two-way mapping between XML documents and 
 * Java objects corresponding to the generated classes. If an input XML file 
 * corresponding to the checkbook.dtd is provided as argument to the application,
 * then the data from the file is binded to the java objects corresponding to the 
 * generated classes. If an input XML file is not provided, then the application 
 * builds an XML document using the generated classes.
 */
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import oracle.xml.classgen.UnmarshalException;
import oracle.xml.classgen.InvalidContentException;

public class CheckbookApp
{
   public static void main (String args[])
   {

      Checkbook checkbook = null;
      if (args.length > 0)
      {
         try
         {
            checkbook = new Checkbook();
            checkbook = Checkbook.unmarshal(createURL(args[0]));
            checkbook.print(System.out);
         }
         catch (UnmarshalException u)
         {
            System.out.println("UnmarshalException thrown: " + u.toString());
            u.printStackTrace();
         }
         catch (InvalidContentException iv)
         {
            System.out.println("InvalidContentException thrown: " + iv.toString());
            iv.printStackTrace();
         }
         catch (IOException io)
         {
            System.out.println("IOException thrown: " + io.toString());
            io.printStackTrace();
         }
      }
      
      else 
      {
         try 
         {
            Date date = new Date("03-09-2001");
            Name name = new Name("Me");
            Amount amount = new Amount("1500.00");
            Deposit deposit = new Deposit();
            deposit.setDate(new Date("03-09-2001"));
            deposit.setName(name);
            deposit.setAmount(amount);
            deposit.setCategory(1);
   
            Check check = new Check("113453");
            check.setDate(date);
            check.setName(new Name("Faberge"));
            check.setAmount(new Amount("34.95"));
            check.setPending(new Pending());
            check.setMemo(new Memo("Faberge Eggs"));
            check.setCategory(1);

            Withdrawal withdrawal = new Withdrawal();
            withdrawal.setDate(new Date("03-27-2001"));
            withdrawal.setAmount(new Amount("20.00"));

            Transactions transaction = new Transactions();
            transaction.setDeposit(deposit);
            transaction.setCheck(check);
            transaction.setWithdrawal(withdrawal);
       
            Balance balance = new Balance("50000.00");
 
            checkbook = new Checkbook();
            checkbook.setTransactions(transaction);
            checkbook.setBalance(balance);

            Check check1 = new Check("913453");
            check1.setDate(new Date("10-10-2001"));
            check1.setName(new Name("Mary Kim"));
            check1.setAmount(new Amount("100.95"));
            check1.setPending(new Pending());
            check1.setMemo(new Memo("Art Material"));
            check1.setCategory(2);

            Transactions trans = checkbook.getTransactions();
            trans.setCheck(check1);

            Balance bal = checkbook.getBalance();
            bal.deleteData("50000.00");
            bal.addData("49000.00");

            checkbook.print(System.out);
         }
         catch (Exception e)
         {
            e.printStackTrace();
         }
      }
   }

   public static URL createURL(String fileName)
                          throws IOException
   {
      URL url = null;

      try
      {
         url = new URL(fileName);
      }
      catch (MalformedURLException ex)
      {
         File f = new File(fileName);

         try
         {
            String path = f.getAbsolutePath();
            // This is a bunch of weird code that is required to
            // make a valid URL on the Windows platform, due
            // to inconsistencies in what getAbsolutePath returns.
            String fs = System.getProperty("file.separator");
            if (fs.length() == 1)
            {
               char sep = fs.charAt(0);
               if (sep != '/')
                  path = path.replace(sep, '/');
               if (path.charAt(0) != '/')
                  path = '/' + path;
            }
            path = "file://" + path;
            url = new URL(path);
         }
         catch (MalformedURLException e)
         {
            throw new IOException(e.toString());
         }
      }

      return url;
   }

}
